<?php

namespace App\Http\Controllers;

use App\Exports\KeuanganExport;
use App\Exports\PengeluaranExport;
use App\Exports\PenjualanExport;
use App\Exports\StokExport;
use App\Models\Pengeluaran;
use App\Models\Rolepengeluaran;
use App\Models\Stok;
use App\Models\Transaksi;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;

class LaporanController extends Controller
{
    public function penjualan()
    {
        $user = User::where('level', '!=', 1)->get();
        $data = [
            'title' => 'Ramizah Store | Laporan Penjualan',
            'page' => 'Laporan Penjualan',
            'menuActive' => 'laporan-penjualan',
            'menuOpen' => 'laporan',
        ];
        return view('admin.laporan.penjualan', compact('data', 'user'));
    }

    public function lap_penjualan(Request $request)
    {
        $petugas = $request->petugas;
        $p = $request->penjualan;
        $via = $request->via;
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;
        if ($p == 1) {
            if ($via == 1) {
                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => 'PEMBAYARAN CASH',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id', $petugas)
                        ->get();
                }
            } else  if ($via == 2) {
                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => 'PEMBAYARAN TRANSFER',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')->where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id', $petugas)
                        ->get();
                }
            } else if ($via == 3) {

                $data = [
                    'jns' => 'TRANSAKSI OFFLINE',
                    'via' => ' ',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('jns_transaksi', 'OFF')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id', $petugas)
                        ->get();
                }
            } else {
                echo 'Data tidak ditemukan';
            }
        } else  if ($p == 2) {
            $data = [
                'jns' => 'TRANSAKSI ONLINE',
                'via' => '',
                'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
            ];
            if ($petugas == 'All') {
                $transaksi = Transaksi::where('jns_transaksi', 'ON')
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                    ->where('sts_transaksi', 'N')
                    ->get();
            } else {
                $transaksi = Transaksi::where('jns_transaksi', 'ON')
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                    ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                    ->where('sts_transaksi', 'N')
                    ->where('user_id', $petugas)
                    ->get();
            }
        } else if ($p == 3) {
            if ($via == 1) {
                $data = [
                    'jns' => '',
                    'via' => 'PEMBAYARAN CASH',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('via_bayar', 'K')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id', $petugas)
                        ->get();
                }
            } else  if ($via == 2) {
                $data = [
                    'jns' => '',
                    'via' => 'PEMBAYARAN TRANSFER',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where('via_bayar', 'T')
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('user_id', $petugas)
                        ->where('sts_transaksi', 'N')
                        ->get();
                }
            } else if ($via == 3) {
                $data = [
                    'jns' => '',
                    'via' => '',
                    'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
                    'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
                ];
                if ($petugas == 'All') {
                    $transaksi = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->get();
                } else {
                    $transaksi = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                        ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                        ->where('sts_transaksi', 'N')
                        ->where('user_id', $petugas)
                        ->get();
                }
            } else {
                echo 'Data tidak ditemukan';
            }
        } else {
            echo 'Data tidak ditemukan';
        }

        if (!empty($transaksi)) {
            return view('admin.laporan.lap_penjualan', compact('transaksi', 'data'))->with('no', 1);
        }
    }

    public function export_lap_penjualan(Request $request)
    {
        $petugas = $request->petugas;
        $penjualan = $request->penjualan;
        $via = $request->via;
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;

        Storage::delete('public/export/data_penjualan.xlsx');
        $name = 'data_penjualan.xlsx';
        Excel::store(new PenjualanExport($petugas, $penjualan, $via, $tgl1, $tgl2), '/public/export/' . $name);
        return response()->json();
    }

    public function penjualan_download()
    {
        return Storage::download('public/export/data_penjualan.xlsx');
    }

    // pengeluran
    public function pengeluaran()
    {
        $data = [
            'title' => 'Ramizah Store | Laporan Pengeluaran',
            'page' => 'Laporan Pengeluaran',
            'menuActive' => 'laporan-pengeluaran',
            'menuOpen' => 'laporan',
        ];
        return view('admin.laporan.pengeluaran', compact('data'));
    }

    public function lap_pengeluaran(Request $request)
    {
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;
        $data = [
            'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
            'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
        ];
        $pengeluaran = Rolepengeluaran::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
            ->get();

        if (!empty($pengeluaran)) {
            return view('admin.laporan.lap_pengeluaran', compact('pengeluaran', 'data'))->with('no', 1);
        } else {
            echo 'Data tidak ditemukan';
        }
    }

    public function export_lap_pengeluaran(Request $request)
    {
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;

        Storage::delete('public/export/data_pengeluaran.xlsx');
        $name = 'data_pengeluaran.xlsx';
        Excel::store(new PengeluaranExport($tgl1, $tgl2), '/public/export/' . $name);
        return response()->json();
    }

    public function pengeluaran_download()
    {
        return Storage::download('public/export/data_pengeluaran.xlsx');
    }

    // stok
    public function stok()
    {
        $user = User::where('level', '!=', 1)->get();
        $data = [
            'title' => 'Ramizah Store | Laporan Stok Masuk',
            'page' => 'Laporan Stok Masuk',
            'menuActive' => 'laporan-stok',
            'menuOpen' => 'laporan',
        ];
        return view('admin.laporan.stok', compact('data', 'user'));
    }

    public function lap_stok(Request $request)
    {
        $petugas = $request->petugas;
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;
        $data = [
            'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
            'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
        ];

        if ($petugas == 'All') {
            $stok = Stok::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                ->get();
        } else {
            $stok = Stok::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
                ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
                ->where('user_id', $petugas)
                ->get();
        }

        if (!empty($stok)) {
            return view('admin.laporan.lap_stok', compact('stok', 'data'))->with('no', 1);
        } else {
            echo 'Data tidak ditemukan';
        }
    }

    public function export_lap_stok(Request $request)
    {
        $petugas = $request->petugas;
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;

        Storage::delete('public/export/data_stok.xlsx');
        $name = 'data_stok.xlsx';
        Excel::store(new StokExport($petugas, $tgl1, $tgl2), '/public/export/' . $name);
        return response()->json();
    }

    public function stok_download()
    {
        return Storage::download('public/export/data_stok.xlsx');
    }

    // keuangan

    public function keuangan()
    {
        $user = User::where('level', '!=', 1)->get();
        $data = [
            'title' => 'Ramizah Store | Laporan Keuangan',
            'page' => 'Laporan Keuangan',
            'menuActive' => 'laporan-keuangan',
            'menuOpen' => 'laporan',
        ];
        return view('admin.laporan.keuangan', compact('data', 'user'));
    }

    public function lap_keuangan(Request $request)
    {
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;
        $data = [
            'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($tgl1)),
            'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($tgl2)),
        ];

        $penjualan = Transaksi::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
            ->selectRaw("SUM(IF(via_bayar ='T', total - ongkir,0)) as jmlt, SUM(IF(via_bayar ='K', total - ongkir,0)) as jmlk, DATE_FORMAT(created_at, '%Y-%m-%d') as tgl, SUM(ongkir) as ok ")
            ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
            ->where('sts_transaksi', 'N')
            ->get();

        $pengeluaran = Rolepengeluaran::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $tgl2)
            ->selectRaw("SUM(total) as jml, DATE_FORMAT(created_at, '%Y-%m-%d') as tgl ")
            ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"))
            ->get();

        return view('admin.laporan.lap_keuangan', compact('penjualan', 'pengeluaran', 'data'))->with('no', 1);
    }

    public function export_lap_keuangan(Request $request)
    {
        $tgl1 = $request->tgl1;
        $tgl2 = $request->tgl2;

        Storage::delete('public/export/data_keuangan.xlsx');
        $name = 'data_keuangan.xlsx';
        Excel::store(new KeuanganExport($tgl1, $tgl2), '/public/export/' . $name);
        return response()->json();
    }

    public function keuangan_download()
    {
        return Storage::download('public/export/data_keuangan.xlsx');
    }
}
